
rm(list = ls())

library(readr)
library(readxl)
library(dplyr)
library(stringr)
library(writexl)
options(scipen=999)

BD <- read.csv("~/EMPAQUETAMIENTO_FIJO_6 (sin).csv", sep=";", dec=",")

colnames(BD)[19] <- "ACCESOS"
colnames(BD)[20] <- "VALOR_FACTURADO"

BD <- filter(BD, ID_ESTADO == 1)
BD <- filter(BD, ACCESOS > 0)
BD <- filter(BD, VALOR_FACTURADO > 99)

BD <- BD[!(BD$ANNO == "2022" & BD$TRIMESTRE == "1"), ]
BD <- BD[!(BD$ANNO == "2022" & BD$TRIMESTRE == "2"), ]

BD$FECHA <- paste(BD$ANNO, "-", BD$TRIMESTRE)
BD$FECHA <- str_replace(BD$FECHA, " - ", "-")

IPC <- read_excel("~/IPC.xlsx")

BD <- merge(BD, IPC, by = c("FECHA"), sort=F, all.x=TRUE)
BD$VALOR_FACTURADO_R <- as.numeric(IPC[12,2])*BD$VALOR_FACTURADO/BD$IPC
BD$P <- BD$VALOR_FACTURADO_R/(3*BD$ACCESOS)

BD_1 <- BD

BD_1 <- merge(BD_1, BD_1 %>% group_by(ID_MUNICIPIO, ID_EMPRESA, ID_SEGMENTO, ID_SERVICIO_PAQUETE, VELOCIDAD_EFECTIVA_DOWNSTREAM, VELOCIDAD_EFECTIVA_UPSTREAM, ID_TECNOLOGIA) %>% summarise(M_P = mean(P), Q1 = quantile(P, 0.25, na.rm = TRUE), Q3 = quantile(P, 0.75, na.rm = TRUE), ME_P = median(P, na.rm = TRUE), ME_ACCESOS = round(median(ACCESOS, na.rm = TRUE)), ME_VALOR_FACTURADO_R = median(VALOR_FACTURADO_R, na.rm = TRUE), SD_P = sd(P), .groups = 'drop') %>% as.data.frame())
BD_1$IQR <- BD_1$Q3 - BD_1$Q1

BD_1$SD_P[is.na(BD_1$SD_P)] <- 0
BD_1$CV_P <- BD_1$SD_P/BD_1$M_P

BD_1$LI_P <- BD_1$Q1 - 1.5*BD_1$IQR
BD_1$LS_P <- BD_1$Q3 + 1.5*BD_1$IQR

BD_1$ACCESOS_2 <- BD_1$ACCESOS
BD_1$VALOR_FACTURADO_R_2 <- BD_1$VALOR_FACTURADO_R

BD_1$ACCESOS_2 <- ifelse(BD_1$P > BD_1$LS_P, BD_1$ME_ACCESOS, BD_1$ACCESOS)
BD_1$ACCESOS_2 <- ifelse(BD_1$P < BD_1$LI_P, BD_1$ME_ACCESOS, BD_1$ACCESOS_2)
BD_1$VALOR_FACTURADO_R_2 <- ifelse(BD_1$P > BD_1$LS_P, BD_1$ME_VALOR_FACTURADO_R, BD_1$VALOR_FACTURADO_R)
BD_1$VALOR_FACTURADO_R_2 <- ifelse(BD_1$P < BD_1$LI_P, BD_1$ME_VALOR_FACTURADO_R, BD_1$VALOR_FACTURADO_R_2)

BD_1$P_2 <- BD_1$VALOR_FACTURADO_R_2/(3*BD_1$ACCESOS_2)

BD_1$VERIFICACION_1 <- ifelse(BD_1$P != BD_1$P_2, 1, 0)
PORCENTAJE_CAMBIOS_1 <- sum(BD_1$VERIFICACION_1)/nrow(BD_1)

BD_1 <- merge(BD_1, BD_1 %>% group_by(ID_MUNICIPIO, ID_EMPRESA, ID_SEGMENTO, ID_SERVICIO_PAQUETE, VELOCIDAD_EFECTIVA_DOWNSTREAM, VELOCIDAD_EFECTIVA_UPSTREAM, ID_TECNOLOGIA) %>% summarise(M_P_2 = mean(P_2), ME_P_2 = median(P_2, na.rm = TRUE), Q1_2 = quantile(ACCESOS_2, 0.25, na.rm = TRUE), Q3_2 = quantile(ACCESOS_2, 0.75, na.rm = TRUE), ME_ACCESOS_2 = round(median(ACCESOS_2, na.rm = TRUE)), ME_VALOR_FACTURADO_R_2 = median(VALOR_FACTURADO_R_2, na.rm = TRUE), SD_P_2 = sd(P_2), SD_ACCESOS_2 = sd(ACCESOS_2), .groups = 'drop') %>% as.data.frame())
BD_1$IQR_2 <- BD_1$Q3_2 - BD_1$Q1_2

BD_1$SD_P_2[is.na(BD_1$SD_P_2)] <- 0
BD_1$SD_ACCESOS_2[is.na(BD_1$SD_ACCESOS_2)] <- 0

BD_1$CV_P_2 <- BD_1$SD_P_2/BD_1$M_P_2

BD_1$COMPARAR <- ifelse(BD_1$CV_P_2 > BD_1$CV_P, 1, 0)
PORCENTAJE_DE_COMPARACION <- sum(BD_1$COMPARAR)/nrow(BD_1)
BD_1$COMPARAR_1 <- BD_1$CV_P_2/BD_1$CV_P-1
hist(BD_1$COMPARAR_1)

BD_1$LI_ACCESOS_2 <- BD_1$Q1_2 - 1.5*BD_1$IQR_2
BD_1$LS_ACCESOS_2 <- BD_1$Q3_2 + 1.5*BD_1$IQR_2
BD_1$ACCESOS_3 <- BD_1$ACCESOS_2
BD_1$ACCESOS_3 <- ifelse(BD_1$COMPARAR != 1, BD_1$ACCESOS_2, ifelse(BD_1$ACCESOS_2 < BD_1$LI_ACCESOS_2, BD_1$ME_ACCESOS_2, BD_1$ACCESOS_3))
BD_1$ACCESOS_3 <- ifelse(BD_1$COMPARAR != 1, BD_1$ACCESOS_2, ifelse(BD_1$ACCESOS_2 > BD_1$LS_ACCESOS_2, BD_1$ME_ACCESOS_2, BD_1$ACCESOS_3))

BD_1$P_3 <- BD_1$VALOR_FACTURADO_R_2/(3*BD_1$ACCESOS_3)

BD_1$VERIFICACION_2 <- ifelse(BD_1$P != BD_1$P_3, 1, 0)
PORCENTAJE_CAMBIOS_2 <- sum(BD_1$VERIFICACION_2)/nrow(BD_1)
CORRECCIONES <- sum(BD_1$VERIFICACION_2)-sum(BD_1$VERIFICACION_1)
PORCENTAJE_DE_CORRECCION_SEGUNDO_PASO <- CORRECCIONES/sum(BD_1$COMPARAR)

BD_1_FINAL <- select(BD_1, FECHA, ANNO, TRIMESTRE, ID_EMPRESA, EMPRESA, ID_MUNICIPIO, MUNICIPIO, ID_DEPARTAMENTO, DEPARTAMENTO, ID_SEGMENTO, SEGMENTO, ID_SERVICIO_PAQUETE, SERVICIO_PAQUETE, VELOCIDAD_EFECTIVA_DOWNSTREAM, VELOCIDAD_EFECTIVA_UPSTREAM, ID_TECNOLOGIA, TECNOLOGIA, ID_ESTADO, ESTADO, IPC, ACCESOS_3, VALOR_FACTURADO_R_2, P_3)

colnames(BD_1_FINAL)[21] <- "ACCESOS"
colnames(BD_1_FINAL)[22] <- "VALOR_FACTURADO_REAL"
colnames(BD_1_FINAL)[23] <- "PRECIO"

write.table(BD_1_FINAL, file = "EMPAQUETAMIENTO_FIJO_6.csv", sep = ";", dec = ",",  row.names = FALSE, col.names = TRUE, fileEncoding = "UTF-8")
